@extends('admin.layouts.main')
@section('title')
    {{ __('page.ABOUT_US') }}
@endsection
@section('pre-title')
    {{ __('page.ABOUT_US') }}
@endsection
@section('page-title')
    <div class="row g-2 align-items-center">
        <div class="col">
            <div class="page-pretitle">
                <a href="{{ url('admin/dashboard') }}">{{ __('page.HOME') }}/</a>
                <a href="{{ url('admin/settings') }}">{{ __('page.SETTINGS') }}/</a>
                @yield('pre-title')
            </div>
            <h2 class="page-title mt-2">
                @yield('title')
            </h2>
        </div>
        <div class="col-auto ms-auto d-print-none">
        </div>
    </div>
@endsection
@section('content')
    <section class="section m-1">
        <div class="card admin_cards">
            <form action="{{ route('settings.about_privacy_terms') }}" method="post" id="about_us_form"
                class="create-form-without-reset">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <span class="help-block text-danger d-none" id="about_us_error">
                            <strong>Please enter aboute us</strong>
                        </span>
                        <div class="col-md-12 mt-2">
                            <textarea id="tinymce_editor" name="about_us" class="form-control col-md-7 col-xs-12" aria-label="tinymce_editor">{{ $settings['about_us'] ?? '' }}</textarea>
                        </div>
                    </div>
                    <div class="col-12 mt-3 d-flex justify-content-end">
                        <button class="btn btn-primary me-1 mb-1" id="about_us_submit" type="submit"
                            name="submit">{{ __('message.SAVE') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection